ALTER TABLE BENS.ACTIVATION_STATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.ACTIVATION_STATE CASCADE CONSTRAINTS;

CREATE TABLE BENS.ACTIVATION_STATE
(
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  ACTIVATION_STATE_ID    NUMBER(20)             NOT NULL,
  STATE_NAME             VARCHAR2(256 BYTE)     NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.ACTIVATION_STATE.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.ACTIVATION_STATE_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.ACTIVATION_STATE.STATE_NAME IS 'State of the activation. Examples include; active, inactive, depreciated, depreciation requested';



CREATE UNIQUE INDEX BENS.ACTST_PK ON BENS.ACTIVATION_STATE
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM ACTIVATION_STATE FOR BENS.ACTIVATION_STATE;


ALTER TABLE BENS.ACTIVATION_STATE ADD (
  CONSTRAINT ACTST_PK
  PRIMARY KEY
  (ACTIVATION_STATE_ID)
  USING INDEX BENS.ACTST_PK
  ENABLE VALIDATE);

GRANT SELECT ON BENS.ACTIVATION_STATE TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.ACTIVATION_STATE TO BENS_RW;

GRANT SELECT ON BENS.ACTIVATION_STATE TO BENS_SEQ_R;
ALTER TABLE BENS.CONTACT_CERTIFICATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.CONTACT_CERTIFICATE CASCADE CONSTRAINTS;

CREATE TABLE BENS.CONTACT_CERTIFICATE
(
  CERTIFICATE_IMAGE       BLOB,
  CONTACT_CERTIFICATE_ID  NUMBER(20)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(20 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER                DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE    DATE,
  ORGANIZATION_ID         NUMBER(20)
)
LOB (CERTIFICATE_IMAGE) STORE AS CONT_CERT_CERT_NME (
  TABLESPACE  M_BENS_DATA_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING

  INDEX       CONT_CERT_CERT_NME_SEG_I)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.CONTACT_CERTIFICATE.ORGANIZATION_ID IS 'This is the sequence-generated primary key for this table.';



CREATE INDEX BENS.CNTCRT_ORG_FK_I ON BENS.CONTACT_CERTIFICATE
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.CNTCRT_PK ON BENS.CONTACT_CERTIFICATE
(CONTACT_CERTIFICATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM CONTACT_CERTIFICATE FOR BENS.CONTACT_CERTIFICATE;


ALTER TABLE BENS.CONTACT_CERTIFICATE ADD (
  CONSTRAINT CNTCRT_PK
  PRIMARY KEY
  (CONTACT_CERTIFICATE_ID)
  USING INDEX BENS.CNTCRT_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.CONTACT_CERTIFICATE ADD (
  CONSTRAINT CONCRT_ORG_FK 
  FOREIGN KEY (ORGANIZATION_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.CONTACT_CERTIFICATE TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_CERTIFICATE TO BENS_RW;

GRANT SELECT ON BENS.CONTACT_CERTIFICATE TO BENS_SEQ_R;
ALTER TABLE BENS.CONTACT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.CONTACT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE BENS.CONTACT_DETAIL
(
  ORGANIZATION_ID          NUMBER(20)           NOT NULL,
  FIRST_NAME               VARCHAR2(30 BYTE),
  LAST_NAME                VARCHAR2(40 BYTE),
  EMAIL_ADDRESS            VARCHAR2(128 BYTE),
  CONTACT_DETAIL_ID        NUMBER(20)           NOT NULL,
  CONTACT_PRECEDENCE_NAME  VARCHAR2(50 BYTE)    NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(20 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER               DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE     DATE
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.CONTACT_DETAIL.ORGANIZATION_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.CONTACT_PRECEDENCE_NAME IS 'Which person to try reaching first, second, etc';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.CONTACT_DETAIL.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';



CREATE INDEX BENS.CNTDTL_ORG_FK_I ON BENS.CONTACT_DETAIL
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.CNTDTL_PK ON BENS.CONTACT_DETAIL
(CONTACT_DETAIL_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM CONTACT_DETAIL FOR BENS.CONTACT_DETAIL;


ALTER TABLE BENS.CONTACT_DETAIL ADD (
  CONSTRAINT CNTDTL_PK
  PRIMARY KEY
  (CONTACT_DETAIL_ID)
  USING INDEX BENS.CNTDTL_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.CONTACT_DETAIL ADD (
  CONSTRAINT CONDET_ORG_FK 
  FOREIGN KEY (ORGANIZATION_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.CONTACT_DETAIL TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_DETAIL TO BENS_RW;

GRANT SELECT ON BENS.CONTACT_DETAIL TO BENS_SEQ_R;
ALTER TABLE BENS.CONTACT_PHONE
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.CONTACT_PHONE CASCADE CONSTRAINTS;

CREATE TABLE BENS.CONTACT_PHONE
(
  PHONE_NUMBER           VARCHAR2(30 BYTE)      NOT NULL,
  PHONE_PRECEDENCE_NAME  VARCHAR2(50 BYTE)      NOT NULL,
  CONTACT_PHONE_ID       NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  CONTACT_DETAIL_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.CONTACT_PHONE.PHONE_PRECEDENCE_NAME IS 'Which phone number to try calling first, second, etc';

COMMENT ON COLUMN BENS.CONTACT_PHONE.CONTACT_PHONE_ID IS 'Priority of which phone number to call; Primary, Secondary, Tierarchiary...';

COMMENT ON COLUMN BENS.CONTACT_PHONE.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.CONTACT_PHONE.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.CONTACT_PHONE.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.CONTACT_PHONE.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.CONTACT_PHONE.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';



CREATE INDEX BENS.CNTPHN_CNTDRL_FK_I ON BENS.CONTACT_PHONE
(CONTACT_DETAIL_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.CNTPHN_PK ON BENS.CONTACT_PHONE
(CONTACT_PHONE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM CONTACT_PHONE FOR BENS.CONTACT_PHONE;


ALTER TABLE BENS.CONTACT_PHONE ADD (
  CONSTRAINT CNTPHN_PK
  PRIMARY KEY
  (CONTACT_PHONE_ID)
  USING INDEX BENS.CNTPHN_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.CONTACT_PHONE ADD (
  CONSTRAINT CONPHN_CONDTL_FK 
  FOREIGN KEY (CONTACT_DETAIL_ID) 
  REFERENCES BENS.CONTACT_DETAIL (CONTACT_DETAIL_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.CONTACT_PHONE TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.CONTACT_PHONE TO BENS_RW;

GRANT SELECT ON BENS.CONTACT_PHONE TO BENS_SEQ_R;
ALTER TABLE BENS.EVENT_CATALOG_ENTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.EVENT_CATALOG_ENTRY CASCADE CONSTRAINTS;

CREATE TABLE BENS.EVENT_CATALOG_ENTRY
(
  RECORD_CREATED_BY       VARCHAR2(20 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER                DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE    DATE,
  EVENT_CATALOG_ENTRY_ID  NUMBER(20)            NOT NULL,
  TAXONOMY_VERSION_ID     NUMBER(20)            NOT NULL,
  EVENT_CLASS_ID          NUMBER(20)            NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.EVENT_CATALOG_ENTRY_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.TAXONOMY_VERSION_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CATALOG_ENTRY.EVENT_CLASS_ID IS 'This is the sequence-generated primary key for this table.';



CREATE INDEX BENS.EVNCTLENT_EVTCLS_FK_I ON BENS.EVENT_CATALOG_ENTRY
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.EVNCTLENT_PK ON BENS.EVENT_CATALOG_ENTRY
(EVENT_CATALOG_ENTRY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCTLENT_TXNVER_FK_I ON BENS.EVENT_CATALOG_ENTRY
(TAXONOMY_VERSION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM EVENT_CATALOG_ENTRY FOR BENS.EVENT_CATALOG_ENTRY;


ALTER TABLE BENS.EVENT_CATALOG_ENTRY ADD (
  CONSTRAINT EVNCTLENT_PK
  PRIMARY KEY
  (EVENT_CATALOG_ENTRY_ID)
  USING INDEX BENS.EVNCTLENT_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.EVENT_CATALOG_ENTRY ADD (
  CONSTRAINT EVNCATENT_TXNVER_FK 
  FOREIGN KEY (TAXONOMY_VERSION_ID) 
  REFERENCES BENS.TAXONOMY_VERSION (TAXONOMY_VERSION_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE,
  CONSTRAINT EVNCTLENT_EVNCLS_FK 
  FOREIGN KEY (EVENT_CLASS_ID) 
  REFERENCES BENS.EVENT_CLASS (EVENT_CLASS_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.EVENT_CATALOG_ENTRY TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CATALOG_ENTRY TO BENS_RW;

GRANT SELECT ON BENS.EVENT_CATALOG_ENTRY TO BENS_SEQ_R;
ALTER TABLE BENS.EVENT_CLASS
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.EVENT_CLASS CASCADE CONSTRAINTS;

CREATE TABLE BENS.EVENT_CLASS
(
  RECORD_CREATED_BY        VARCHAR2(20 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER               DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE     DATE,
  EVENT_CLASS_ID           NUMBER(20),
  PLANNED_INACTIVATE_DATE  DATE,
  PARENT_EVENT_CLASS_ID    NUMBER(20),
  EVENT_CODE_ID            NUMBER(20)           NOT NULL,
  ACTIVATION_STATE_ID      NUMBER(20)           NOT NULL,
  SPONSOR_ID               NUMBER(20)           NOT NULL,
  ACTIVATE_DATE            DATE,
  INACTIVATE_DATE          DATE
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.EVENT_CLASS.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.EVENT_CLASS.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.EVENT_CLASS.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.EVENT_CLASS.EVENT_CLASS_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS.PARENT_EVENT_CLASS_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS.EVENT_CODE_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS.ACTIVATION_STATE_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS.SPONSOR_ID IS 'This is the sequence-generated primary key for this table.';



CREATE INDEX BENS.EVNCLS_ACTST_FK_I ON BENS.EVENT_CLASS
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCLS_EVNCOD_FK_I ON BENS.EVENT_CLASS
(EVENT_CODE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCLS_PEVNCLS_FK_I ON BENS.EVENT_CLASS
(PARENT_EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.EVNCLS_PK ON BENS.EVENT_CLASS
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCLS_SPN_FK_I ON BENS.EVENT_CLASS
(SPONSOR_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM EVENT_CLASS FOR BENS.EVENT_CLASS;


ALTER TABLE BENS.EVENT_CLASS ADD (
  CONSTRAINT EVNCLS_PK
  PRIMARY KEY
  (EVENT_CLASS_ID)
  USING INDEX BENS.EVNCLS_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.EVENT_CLASS ADD (
  CONSTRAINT EVNCLS_ACTST_FK 
  FOREIGN KEY (ACTIVATION_STATE_ID) 
  REFERENCES BENS.ACTIVATION_STATE (ACTIVATION_STATE_ID)
  ENABLE VALIDATE,
  CONSTRAINT EVNCLS_EVNCLS_FK 
  FOREIGN KEY (PARENT_EVENT_CLASS_ID) 
  REFERENCES BENS.EVENT_CLASS (EVENT_CLASS_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE,
  CONSTRAINT EVNCLS_EVNCOD_FK 
  FOREIGN KEY (EVENT_CODE_ID) 
  REFERENCES BENS.EVENT_CODE (EVENT_CODE_ID)
  ENABLE VALIDATE,
  CONSTRAINT EVNCLS_ORG_FK 
  FOREIGN KEY (SPONSOR_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON BENS.EVENT_CLASS TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS TO BENS_RW;

GRANT SELECT ON BENS.EVENT_CLASS TO BENS_SEQ_R;
ALTER TABLE BENS.EVENT_CLASS_COMMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.EVENT_CLASS_COMMENT CASCADE CONSTRAINTS;

CREATE TABLE BENS.EVENT_CLASS_COMMENT
(
  COMMENT_TEXT            VARCHAR2(4000 BYTE),
  EVENT_CLASS_ID          NUMBER(20)            NOT NULL,
  EVENT_CLASS_COMMENT_ID  NUMBER(20)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(20 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER                DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE    DATE
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.EVENT_CLASS_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS_COMMENT.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';



CREATE INDEX BENS.EVNCLSCOM_EVNCLS_FK_I ON BENS.EVENT_CLASS_COMMENT
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.EVNCLSCOM_PK ON BENS.EVENT_CLASS_COMMENT
(EVENT_CLASS_COMMENT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM EVENT_CLASS_COMMENT FOR BENS.EVENT_CLASS_COMMENT;


ALTER TABLE BENS.EVENT_CLASS_COMMENT ADD (
  CONSTRAINT EVNCLSCOM_PK
  PRIMARY KEY
  (EVENT_CLASS_COMMENT_ID)
  USING INDEX BENS.EVNCLSCOM_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.EVENT_CLASS_COMMENT ADD (
  CONSTRAINT EVNCLSCOM_EVNCLS_FK 
  FOREIGN KEY (EVENT_CLASS_ID) 
  REFERENCES BENS.EVENT_CLASS (EVENT_CLASS_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.EVENT_CLASS_COMMENT TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS_COMMENT TO BENS_RW;

GRANT SELECT ON BENS.EVENT_CLASS_COMMENT TO BENS_SEQ_R;
ALTER TABLE BENS.EVENT_CLASS_REGISTRANT
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.EVENT_CLASS_REGISTRANT CASCADE CONSTRAINTS;

CREATE TABLE BENS.EVENT_CLASS_REGISTRANT
(
  RECORD_CREATED_BY          VARCHAR2(20 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER             DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  EVENT_CLASS_REGISTRANT_ID  NUMBER(20)         NOT NULL,
  RELATIONSHIP_TYPE_NAME     VARCHAR2(20 BYTE)  NOT NULL,
  REGISTRANT_ID              NUMBER(20)         NOT NULL,
  EVENT_CLASS_ID             NUMBER(20)         NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.EVENT_CLASS_REGISTRANT_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.RELATIONSHIP_TYPE_NAME IS 'An Event Class Registrant may be a publisher or subscriber';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.REGISTRANT_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.EVENT_CLASS_REGISTRANT.EVENT_CLASS_ID IS 'This is the sequence-generated primary key for this table.';



CREATE INDEX BENS.EVNCLSRGS_EVNCLS_FK_I ON BENS.EVENT_CLASS_REGISTRANT
(EVENT_CLASS_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.EVNCLSRGS_PK ON BENS.EVENT_CLASS_REGISTRANT
(EVENT_CLASS_REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCLSRGS_REG_FK_I ON BENS.EVENT_CLASS_REGISTRANT
(REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.EVNCLSRGS_RELTYPNAM_NU_I ON BENS.EVENT_CLASS_REGISTRANT
(RELATIONSHIP_TYPE_NAME)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM EVENT_CLASS_REGISTRANT FOR BENS.EVENT_CLASS_REGISTRANT;


ALTER TABLE BENS.EVENT_CLASS_REGISTRANT ADD (
  CONSTRAINT EVNCLSRGS_PK
  PRIMARY KEY
  (EVENT_CLASS_REGISTRANT_ID)
  USING INDEX BENS.EVNCLSRGS_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.EVENT_CLASS_REGISTRANT ADD (
  CONSTRAINT EVNCLSREG_EVNCLS_FK 
  FOREIGN KEY (EVENT_CLASS_ID) 
  REFERENCES BENS.EVENT_CLASS (EVENT_CLASS_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE,
  CONSTRAINT EVNCLSREG_REG_FK 
  FOREIGN KEY (REGISTRANT_ID) 
  REFERENCES BENS.REGISTRANT (REGISTRANT_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.EVENT_CLASS_REGISTRANT TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CLASS_REGISTRANT TO BENS_RW;

GRANT SELECT ON BENS.EVENT_CLASS_REGISTRANT TO BENS_SEQ_R;
ALTER TABLE BENS.EVENT_CODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.EVENT_CODE CASCADE CONSTRAINTS;

CREATE TABLE BENS.EVENT_CODE
(
  RECORD_CREATED_BY           VARCHAR2(20 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER            DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE        DATE,
  EVENT_CODE_ID               NUMBER(20)        NOT NULL,
  CODE_NAME                   VARCHAR2(20 BYTE) NOT NULL,
  VALUE_NAME                  VARCHAR2(20 BYTE) NOT NULL,
  CODING_SYSTEM_NAME          VARCHAR2(20 BYTE) NOT NULL,
  CODING_SYSTEM_VERSION_TEXT  VARCHAR2(20 BYTE)
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.EVENT_CODE.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.EVENT_CODE.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.EVENT_CODE.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.EVENT_CODE.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.EVENT_CODE.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.EVENT_CODE.EVENT_CODE_ID IS 'This is the sequence-generated primary key for this table.';



CREATE UNIQUE INDEX BENS.EVNCOD_PK ON BENS.EVENT_CODE
(EVENT_CODE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM EVENT_CODE FOR BENS.EVENT_CODE;


ALTER TABLE BENS.EVENT_CODE ADD (
  CONSTRAINT EVNCOD_PK
  PRIMARY KEY
  (EVENT_CODE_ID)
  USING INDEX BENS.EVNCOD_PK
  ENABLE VALIDATE);

GRANT SELECT ON BENS.EVENT_CODE TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.EVENT_CODE TO BENS_RW;

GRANT SELECT ON BENS.EVENT_CODE TO BENS_SEQ_R;
ALTER TABLE BENS.ORGANIZATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.ORGANIZATION CASCADE CONSTRAINTS;

CREATE TABLE BENS.ORGANIZATION
(
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  ORGANIZATION_ID        NUMBER(20)             NOT NULL,
  ORGANIZATION_NAME      VARCHAR2(80 BYTE),
  SYSTEM_NAME            VARCHAR2(80 BYTE),
  APPLICATION_NAME       VARCHAR2(80 BYTE)
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.ORGANIZATION.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.ORGANIZATION.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.ORGANIZATION.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.ORGANIZATION.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.ORGANIZATION.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.ORGANIZATION.ORGANIZATION_ID IS 'This is the sequence-generated primary key for this table.';



CREATE UNIQUE INDEX BENS.ORG_PK ON BENS.ORGANIZATION
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM ORGANIZATION FOR BENS.ORGANIZATION;


ALTER TABLE BENS.ORGANIZATION ADD (
  CONSTRAINT ORG_PK
  PRIMARY KEY
  (ORGANIZATION_ID)
  USING INDEX BENS.ORG_PK
  ENABLE VALIDATE);

GRANT SELECT ON BENS.ORGANIZATION TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.ORGANIZATION TO BENS_RW;

GRANT SELECT ON BENS.ORGANIZATION TO BENS_SEQ_R;
ALTER TABLE BENS.ORGANIZATION_COMMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.ORGANIZATION_COMMENT CASCADE CONSTRAINTS;

CREATE TABLE BENS.ORGANIZATION_COMMENT
(
  COMMENT_TEXT             VARCHAR2(4000 BYTE),
  ORGANIZATION_ID          NUMBER(20)           NOT NULL,
  ORGANIZATION_COMMENT_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(20 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER               DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE     DATE
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.ORGANIZATION_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.ORGANIZATION_COMMENT.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';



CREATE INDEX BENS.ORGCOM_ORG_FK_I ON BENS.ORGANIZATION_COMMENT
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.ORGCOM_PK ON BENS.ORGANIZATION_COMMENT
(ORGANIZATION_COMMENT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM ORGANIZATION_COMMENT FOR BENS.ORGANIZATION_COMMENT;


ALTER TABLE BENS.ORGANIZATION_COMMENT ADD (
  CONSTRAINT ORGCOM_PK
  PRIMARY KEY
  (ORGANIZATION_COMMENT_ID)
  USING INDEX BENS.ORGCOM_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.ORGANIZATION_COMMENT ADD (
  CONSTRAINT ORGCOM_ORG_FK 
  FOREIGN KEY (ORGANIZATION_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON BENS.ORGANIZATION_COMMENT TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.ORGANIZATION_COMMENT TO BENS_RW;

GRANT SELECT ON BENS.ORGANIZATION_COMMENT TO BENS_SEQ_R;
ALTER TABLE BENS.REGISTRANT
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.REGISTRANT CASCADE CONSTRAINTS;

CREATE TABLE BENS.REGISTRANT
(
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  REGISTRANT_ID          NUMBER(20)             NOT NULL,
  ACTIVATE_DATE          DATE,
  INACTIVATE_DATE        DATE,
  ACTIVATION_STATE_ID    NUMBER(20)             NOT NULL,
  ORGANIZATION_ID        NUMBER(20)             NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.REGISTRANT.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.REGISTRANT.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.REGISTRANT.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.REGISTRANT.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.REGISTRANT.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.REGISTRANT.REGISTRANT_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.REGISTRANT.ACTIVATION_STATE_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.REGISTRANT.ORGANIZATION_ID IS 'This is the sequence-generated primary key for this table.';



CREATE INDEX BENS.REG_ACRST_FK_I ON BENS.REGISTRANT
(ACTIVATION_STATE_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.REG_ORG_FK_I ON BENS.REGISTRANT
(ORGANIZATION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE UNIQUE INDEX BENS.REG_PK ON BENS.REGISTRANT
(REGISTRANT_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM REGISTRANT FOR BENS.REGISTRANT;


ALTER TABLE BENS.REGISTRANT ADD (
  CONSTRAINT REG_PK
  PRIMARY KEY
  (REGISTRANT_ID)
  USING INDEX BENS.REG_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.REGISTRANT ADD (
  CONSTRAINT REG_ACTST_FK 
  FOREIGN KEY (ACTIVATION_STATE_ID) 
  REFERENCES BENS.ACTIVATION_STATE (ACTIVATION_STATE_ID)
  ENABLE VALIDATE,
  CONSTRAINT REG_ORG_FK 
  FOREIGN KEY (ORGANIZATION_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ENABLE VALIDATE);

GRANT SELECT ON BENS.REGISTRANT TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.REGISTRANT TO BENS_RW;

GRANT SELECT ON BENS.REGISTRANT TO BENS_SEQ_R;
ALTER TABLE BENS.TAXONOMY
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.TAXONOMY CASCADE CONSTRAINTS;

CREATE TABLE BENS.TAXONOMY
(
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  TAXONOMY_ID            NUMBER(20)             NOT NULL,
  TAXONOMY_NAME          VARCHAR2(20 BYTE)      NOT NULL,
  SPONSOR_ID             NUMBER(20)             NOT NULL
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.TAXONOMY.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.TAXONOMY.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.TAXONOMY.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.TAXONOMY.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.TAXONOMY.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.TAXONOMY.TAXONOMY_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.TAXONOMY.SPONSOR_ID IS 'This is the sequence-generated primary key for this table.';



CREATE UNIQUE INDEX BENS.TAX_PK ON BENS.TAXONOMY
(TAXONOMY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.TAX_SPN_FK_I ON BENS.TAXONOMY
(SPONSOR_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM TAXONOMY FOR BENS.TAXONOMY;


ALTER TABLE BENS.TAXONOMY ADD (
  CONSTRAINT TAX_PK
  PRIMARY KEY
  (TAXONOMY_ID)
  USING INDEX BENS.TAX_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.TAXONOMY ADD (
  CONSTRAINT TXN_ORG_FK 
  FOREIGN KEY (SPONSOR_ID) 
  REFERENCES BENS.ORGANIZATION (ORGANIZATION_ID)
  ON DELETE SET NULL
  ENABLE VALIDATE);

GRANT SELECT ON BENS.TAXONOMY TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.TAXONOMY TO BENS_RW;

GRANT SELECT ON BENS.TAXONOMY TO BENS_SEQ_R;
ALTER TABLE BENS.TAXONOMY_VERSION
 DROP PRIMARY KEY CASCADE;

DROP TABLE BENS.TAXONOMY_VERSION CASCADE CONSTRAINTS;

CREATE TABLE BENS.TAXONOMY_VERSION
(
  RECORD_CREATED_BY      VARCHAR2(20 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER                 DEFAULT 0                     NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(20 BYTE),
  RECORD_MODIFIED_DATE   DATE,
  TAXONOMY_VERSION_ID    NUMBER(20)             NOT NULL,
  TAXONOMY_ID            NUMBER(20)             NOT NULL,
  ACTIVATE_DATE          DATE,
  INACTIVATE_DATE        DATE,
  VERSION_NUMBER         VARCHAR2(20 BYTE)
)
TABLESPACE M_BENS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.RECORD_CREATED_BY IS 'This is the system ID of the individual or application that created this record.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.RECORD_CREATED_DATE IS 'This is the date this record was created.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.RECORD_MODIFIED_COUNT IS 'This is the number of times this record has been modified.  Defaults to 0.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.RECORD_MODIFIED_BY IS 'This is the system ID of the individual or application that last modified this record.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.RECORD_MODIFIED_DATE IS 'This is the date on which the record was last updated.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.TAXONOMY_VERSION_ID IS 'This is the sequence-generated primary key for this table.';

COMMENT ON COLUMN BENS.TAXONOMY_VERSION.TAXONOMY_ID IS 'This is the sequence-generated primary key for this table.';



CREATE UNIQUE INDEX BENS.TAXVER_PK ON BENS.TAXONOMY_VERSION
(TAXONOMY_VERSION_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE INDEX BENS.TAXVER_TAX_FK_I ON BENS.TAXONOMY_VERSION
(TAXONOMY_ID)
LOGGING
TABLESPACE M_BENS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;


CREATE OR REPLACE PUBLIC SYNONYM TAXONOMY_VERSION FOR BENS.TAXONOMY_VERSION;


ALTER TABLE BENS.TAXONOMY_VERSION ADD (
  CONSTRAINT TAXVER_PK
  PRIMARY KEY
  (TAXONOMY_VERSION_ID)
  USING INDEX BENS.TAXVER_PK
  ENABLE VALIDATE);

ALTER TABLE BENS.TAXONOMY_VERSION ADD (
  CONSTRAINT TXNVER_TXN_FK 
  FOREIGN KEY (TAXONOMY_ID) 
  REFERENCES BENS.TAXONOMY (TAXONOMY_ID)
  ENABLE VALIDATE);

GRANT SELECT ON BENS.TAXONOMY_VERSION TO BENS_R;

GRANT INSERT, SELECT, UPDATE ON BENS.TAXONOMY_VERSION TO BENS_RW;

GRANT SELECT ON BENS.TAXONOMY_VERSION TO BENS_SEQ_R;
